// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : VSsheep[ sceneEffect.h ]		Auter : KENSUKE WATANABE
//											Data  : 2016/08/30
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2016/08/30
//
// ======== ======== ======== ======== ======== ======== ======== ========
#ifndef _EFFECT3DPOLY_H_
#define _EFFECT3DPOLY_H_

#include <vector>
#include "scene3D.h"
#define NUM_VERTEX		( 4 )		// _
#define NUM_POLYGON		( 2 )		// |S(v~eBu)

static const char* TEXNAME_EFFECT_WTOBLINE = { "data/TEXTURE/BG/WtoBline.png" };

class CEffect3DPoly
{
public:
	CEffect3DPoly() {}
	~CEffect3DPoly() {}

	void Init(void);
	void Uninit(void);
	static void UpdateAll(void);
	static void DrawAll(void);
	static void Create(int n, std::string texName);
	static void SetEffect3DPoly(D3DXVECTOR3 pos, D3DXVECTOR3 rot, D3DXVECTOR3 move, float radius, int r, int g, int b, int a, int life, std::string texName);
	static void FlashAll(void);
	static void ReleaseAll(void);

	static HRESULT MakeVertexEffect();	// |S_쐬
	void SetEffectVertex(VERTEX_3D* pVtx, int n);		// _ݒ

	static std::vector<CEffect3DPoly> *GetVecEffect3DPoly(void) { return &m_vecEffect3DPoly; }

private: 
	float m_fRadius;			// a
	float m_fRadiusValue;		// aω
	float m_fColorAlphaValue;	// l̕ω
	bool m_bUse;				// gĂ邩
	int m_nLife;				// 

	D3DXVECTOR3 m_pos;			// W
	D3DXVECTOR3 m_move;			// ړ
	D3DXVECTOR3 m_scl;			// g嗦
	D3DXVECTOR3 m_rot;			// ]p
	D3DXVECTOR3 m_size;			// TCY
	int m_r, m_g, m_b, m_a;

	std::string m_strFilePass;	// eNX`FilePass
	D3DXMATRIX m_mtxWorld;		// [h}gNX

	static LPDIRECT3DVERTEXBUFFER9 m_pVtxBuffer;	// Vtxobt@
	static int m_maxEffect;
	static int m_cnt;

	static std::vector<CEffect3DPoly> m_vecEffect3DPoly;
};

#endif
